import gym
import numpy as np

from highway_env.road.lane import StraightLane
from highway_env.vehicle.kinematics import Vehicle


# %matplotlib qt

env = gym.make("complex_city-v0")
env.configure({
    "screen_width": 1280,
    "screen_height": 1000
})
env.reset()
term = False

# Set initial destination for the ego_car
destination = env.road.network.get_random_destination()

#print(env.observation_space, env.action_space)
print('destination:', destination)
ego_car = env.controlled_vehicles[0]

#print('speed', ego_car.speed, ego_car.position)
lane = ego_car.lane
#print('lane (index)', ego_car.lane_index, lane.start, lane.end)

ego_car.plan_route_to(destination)
i = 0
while not term and i < 27:
    road_network = env.road.network
    action = 0
    obs_space, rew, term, trunc, info = env.step(action)

    ego_car.lane.distance(ego_car.position)
    #print('lane (index)', ego_car.lane)
    #print(obs_space, rew, info)
    if len(ego_car.route) < 2:
        new_destination = env.road.network.get_random_destination()
        ego_car.plan_route_to(new_destination)
        print('tijd voor een nieuwe route vriend')
        i += 1
    ## car
    #print(ego_car.route)
    env.render()


####
